-- GROUP BY --
-- SUM, MIN, MAX, AVG ve COUNT Aggregate Fonksiyonlardr. Bunlarla eklediimiz tm stunlardan
-- baka stunlar group by'da yazmamz gerekiyor.
select degerlendiren, COUNT(*) puansayisi from Degerlendirme group by degerlendiren
-- deerlendirenlere gre puan saylar
select degerlendiren, MAX(puani) maksimumpuan from Degerlendirme group by degerlendiren
-- deerlendirenlere gre maksimum puanlar
select degerlendiren, MIN(puani) minimumpuan from Degerlendirme group by degerlendiren
-- deerlendirenlere gre minimum puanlar
select film_id, MAX(puani) maksimumpuan from Degerlendirme group by film_id
-- filmlere gre maksimum puanlar
select film_id, MIN(puani) minimumpuan from Degerlendirme group by film_id
-- filmlere gre minimum puanlar
select film_id, COUNT(*) puansayisi from Degerlendirme group by film_id
-- filmlere gre puan saylar
select film_id, (SUM(puani) / COUNT(*)) ortalamapuan from Degerlendirme group by film_id
-- filmlere gre puan ortalamalar
select film_id, AVG(puani) ortalamapuan from Degerlendirme group by film_id
-- filmlere gre puan ortalamalar
select film_id, AVG(CAST(puani as float)) ortalamapuan from Degerlendirme group by film_id
-- filmlere gre puan ortalamalar: doru sonu iin cast ile veri dntrmeye dikkat etmek gerekli!
select f.adi, f.yapimyili, f.gisesi, AVG(CAST(d.puani as float)) ortalamapuan from Film f 
left outer join Degerlendirme d on f.id = d.film_id
group by f.adi, f.yapimyili, f.gisesi
-- filmlere gre puan ortalamalar
select f.adi, f.yapimyili, f.gisesi, AVG(CAST(d.puani as float)) ortalamapuan from Film f 
left outer join Degerlendirme d on f.id = d.film_id
group by f.adi, f.yapimyili, f.gisesi
having AVG(CAST(d.puani as float)) > 60
-- filmlere gre puan ortalamalar 60'tan byk olanlar
select f.adi, f.yapimyili, f.gisesi, AVG(CAST(d.puani as float)) ortalamapuan, COUNT(*) puansayisi from Film f 
left outer join Degerlendirme d on f.id = d.film_id
group by f.adi, f.yapimyili, f.gisesi
having AVG(CAST(d.puani as float)) > 60 and COUNT(*) > 1
-- filmlere gre puan ortalamalar 60'tan byk ve puan saylar 1'den byk olanlar

-- Soru: Film adlar ile oyuncu saylarn getiren sorgu?
use Filmler
select f.adi as filmadi, COUNT(o.id) as oyuncusayisi 
from Film as f inner join FilmOyuncuKarakter as fok on f.id = fok.film_id
inner join Oyuncu as o on fok.oyuncu_id = o.id 
group by f.adi
-- Soru: Hangi oyuncu ka filmde oynam?
select Oyuncu.id as oyuncuid, Oyuncu.adi as oyuncuadi, Oyuncu.soyadi as oyuncusoyadi, 
CONVERT(varchar(10), Oyuncu.dogumtarihi, 104) as oyuncudogumtarihi, 
CAST(COUNT(*) as varchar(3)) as oyuncutoplamfilmsayisi
from Oyuncu, FilmOyuncuKarakter, Film
where Oyuncu.id = FilmOyuncuKarakter.oyuncu_id
and FilmOyuncuKarakter.film_id = Film.id
group by Oyuncu.id, Oyuncu.adi, Oyuncu.soyadi, Oyuncu.dogumtarihi
order by oyuncutoplamfilmsayisi
-- Soru: Hangi ynetmen hangi filmle ne kadar gie haslat yapm?
select y.adi + ' ' + y.soyadi as yonetmen, SUM(f.gisesi) as toplamgise 
from Yonetmen as y inner join Film as f on y.id = f.yonetmen_id
group by y.adi, y.soyadi
-- WITH ROLLUP - WITH CUBE --
-- ROLLUP: Gruplanm kolonlarn hiyerarisine gre zet satr oluturur. 
-- GROUP BY deyiminde kullanlm kolon says kadar gruplama tipi gerekletirir.
-- GROUP BY deyiminde verilmi kolonlar sadan sola doru gruplar 
-- ve ona gre her grubun altnda zet satr oluturur.
-- CUBE: Deerlerin tm kombinasyonlar iin ara zet satr oluturur.
-- CUBE, ROLLUP gibi zet satr oluturur. Tek fark, GROUP BY deyiminde kullanlm 
-- kolonlarn deerlerinin btn kombinasyonlar kadar group zeti yapar.
-- NOT: WITH CUBE veya WITH ROLLUP operatrleri ayn anda en fazla 10 kolon (krlm noktas) 
-- zerinde zetleme yapabilir.
-- Soru: Oyuncu ad ve soyadlarna gre oynadklar filmlerin toplam gie haslatlar?
select Oyuncu.adi as oyuncuadi, Oyuncu.soyadi as oyuncusoyadi, 
SUM(Film.gisesi) as oynadigifilmlertoplamgisesi 
from Oyuncu inner join FilmOyuncuKarakter on Oyuncu.id = FilmOyuncuKarakter.oyuncu_id
inner join Film on FilmOyuncuKarakter.film_id = Film.id
group by Oyuncu.adi, Oyuncu.soyadi
order by Oyuncu.adi
-- WITH ROLLUP'l hali:
select Oyuncu.adi as oyuncuadi, Oyuncu.soyadi as oyuncusoyadi, 
SUM(Film.gisesi) as oynadigifilmlertoplamgisesi 
from Oyuncu inner join FilmOyuncuKarakter on Oyuncu.id = FilmOyuncuKarakter.oyuncu_id
inner join Film on FilmOyuncuKarakter.film_id = Film.id
group by Oyuncu.adi, Oyuncu.soyadi with rollup
order by Oyuncu.adi
-- Satr 1'de NULL, NULL, 73600000,00 deerleri dnyor.
-- Bunun anlam WITH ROLLUP bize 73600000,00' bu deerin olduu satrn altndaki 
-- tm toplam gise deerlerini toplayp veriyor.
-- Satr 2'de Carrie, Henn, 10000000,00 deerleri dnyor.
-- Bunun anlam WITH ROLLUP bize sadece Carrie Henn'in toplam gie deerini veriyor.
-- Satr 3'te Carrie, NULL, 10000000,00 deerleri dnyor.
-- Bunun anlam WITH ROLLUP bize 10000000,00' tm Carrie isimlerinin toplam gie 
-- deerlerini toplayp veriyor.
-- Satr 4'te Charles, Dance, 4000000,00 deerleri dnyor.
-- Bunun anlam WITH ROLLUP bize sadece Charles Dance'in toplam gie deerini veriyor.
-- Satr 5'te Charles, Dutton, 4000000,00 deerleri dnyor.
-- Bunun anlam WITH ROLLUP bize sadece Charles Dutton'un toplam gie deerini veriyor.
-- Satr 6'da Charles, NULL, 8000000,00 deerleri dnyor.
-- Bunun anlam WITH ROLLUP bize 8000000,00'i tm Charles isimlerinin toplam gie 
-- deerlerini toplayp veriyor.
-- Dier satrlar da Satr 2 ve Satr 3'teki zellikleri gsteriyor.
-- WITH CUBE'lu hali:
select Oyuncu.adi as oyuncuadi, Oyuncu.soyadi as oyuncusoyadi, 
SUM(Film.gisesi) as oynadigifilmlertoplamgisesi 
from Oyuncu inner join FilmOyuncuKarakter on Oyuncu.id = FilmOyuncuKarakter.oyuncu_id
inner join Film on FilmOyuncuKarakter.film_id = Film.id
group by Oyuncu.adi, Oyuncu.soyadi with cube
order by Oyuncu.adi
-- lk 17 satr NULL, OyuncuSoyad, ToplamGieDeeri eklinde dnyor.
-- Bunun amac oyuncu soyadlarna gre de zet toplam gie deerleri toplam karmak.
-- 18. satr WITH ROLLUP'n dndrd 1. satrdaki gibi NULL, NULL, ToplamGieDeerleriToplam
-- eklinde dnyor.
-- 19. satrdan itibaren WITH ROLLUP'n 2. satrdan itibaren dndrd gibi deerler dnyor.
-- SONU:
-- WITH ROLLUP ve WITH CUBE GROUP BY'daki stun adlarna gre zetlemeler yapar.
-- WITH ROLLUP en sadaki stundan en soldaki stuna doru zetlemeler yapar.
-- WITH CUBE ise WITH ROLLUP'tan farkl olarak GROUP BY'da kullanlm stunlardaki deerlerin 
-- tm kombinasyonlar iin zetlemeler yapar.
-- Soru: Oyuncu ID, ad ve soyadlarna gre ID'si 4 ve daha kk olan oyuncularn oynadklar 
-- filmlerin toplam gie haslatlar?
-- HAVING --
select Oyuncu.id as oyuncuid, Oyuncu.adi as oyuncuadi, Oyuncu.soyadi as oyuncusoyadi, 
SUM(Film.gisesi) as oynadigifilmlertoplamgisesi 
from Oyuncu inner join FilmOyuncuKarakter on Oyuncu.id = FilmOyuncuKarakter.oyuncu_id
inner join Film on FilmOyuncuKarakter.film_id = Film.id
group by Oyuncu.id, Oyuncu.adi, Oyuncu.soyadi having(Oyuncu.id <= 4)
order by Oyuncu.id
-- Oyuncu ID'si 4 ve daha kk olan oyuncularn ID, ad ve soyadlar ile birlikte 
-- oynadklar filmlerin toplam gieleri
select Oyuncu.id as oyuncuid, Oyuncu.adi as oyuncuadi, Oyuncu.soyadi as oyuncusoyadi, 
SUM(Film.gisesi) as oynadigifilmlertoplamgisesi 
from Oyuncu inner join FilmOyuncuKarakter on Oyuncu.id = FilmOyuncuKarakter.oyuncu_id
inner join Film on FilmOyuncuKarakter.film_id = Film.id
where Oyuncu.id <= 4
group by Oyuncu.id, Oyuncu.adi, Oyuncu.soyadi
order by Oyuncu.id
-- having(Oyuncu.id <= 4) : having bir aggregate fonksiyon zerinden kullanlmadnda where Oyuncu.id <= 4 gibi dnlebilir.